<?php

function changeRtsp($rtsp, $arr, $sock, $index)
{
   if (!isset($rtsp)) {
      return;
   }

   if ($rtsp === "TCP") {
      if (isset($arr->usetcp)) {
         if ($arr->usetcp != 1) {
            ParamSetInt($sock, "video.input.[" . $index . "].usetcp", 1);
         }
      } else {
         ParamSetInt($sock, "video.input.[" . $index . "].usetcp", 1);
      }
      if (isset($arr->usetcp2)) {
         if ($arr->usetcp2 != 1) {
            ParamSetInt($sock, "video.input.[" . $index . "].usetcp2", 1);
         }
      } else {
         ParamSetInt($sock, "video.input.[" . $index . "].usetcp2", 1);
      }
      return;
   }

   if ($rtsp === "UDP") {
      if (isset($arr->usetcp)) {
         ParamUnset($sock, "video.input.[" . $index . "].usetcp");
      }
      if (isset($arr->usetcp2)) {
         ParamUnset($sock, "video.input.[" . $index . "].usetcp2");
      }
      return;
   }
}

function changeUserName($username, $arr, $sock, $index, $value = false)
{
   if (isset($username) && $username == "") {
      return $value;
   }

   if (isset($arr->username)) {
      if ($arr->username != $username) {
         return ParamSetString($sock, "video.input.[" . $index . "].username", $username);
      }
      return $value;
   }
   return ParamSetString($sock, "video.input.[" . $index . "].username", $username);
}

function changePassChannel($pass, $arr, $sock, $index, $value = false)
{
   if (!isset($pass) || $pass == "") {
      return $value;
   }
   echo json_encode($arr);

   if (isset($arr->cam_password)) {
      if ($arr->cam_password != $pass) {
         return ParamSetString($sock, "video.input.[" . $index . "].cam_password", $pass);
      }
      return $value;
   }

   return ParamSetString($sock, "video.input.[" . $index . "].cam_password", $pass);
}

function changeName($name, $arr, $sock, $index)
{
   if (isset($name) && $name != "") {
      if (isset($arr->title1251)) {
         if ($arr->title1251 != $name) {
            ParamSetString($sock, "video.input.[" . $index . "].title1251", $name);
            ParamSetString($sock, "video.input.[" . $index . "].titleUtf", $name, false);
         }
         return;
      }

      ParamSetString($sock, "video.input.[" . $index . "].title1251", $name);
      ParamSetString($sock, "video.input.[" . $index . "].titleUtf", $name, false);

      return;
   }

   ParamUnset($sock, "video.input.[" . $index . "].title1251");
   ParamUnset($sock, "video.input.[" . $index . "].titleUtf");
}

function changeTimeout($timeout, $arr, $sock, $index)
{
   if (!isset($timeout)) {
      return;
   }

   if (isset($arr->timeout)) {
      if ($arr->timeout != $timeout) {
         ParamSetInt($sock, "video.input.[" . $index . "].timeout", $timeout);
      }
      return;
   }

   ParamSetInt($sock, "video.input.[" . $index . "].timeout", $timeout);
}

function changeIp($ip, $arr, $sock, $index, $value = false)
{
   if (!isset($ip)) {
      return $value;
   }

   if (isset($arr->ip) && $arr->ip !== "") {
      if ($arr->ip != $ip) {
         return ParamSetString($sock, "video.input.[" . $index . "].ip", $ip);
      }
      return $value;
   }

   return ParamSetString($sock, "video.input.[" . $index . "].ip", $ip);
}

function changePortRtsp($port_rtsp, $arr, $sock, $index)
{
   if (!isset($port_rtsp)) {
      return;
   }

   if (isset($arr->port)) {
      if ($arr->port != $port_rtsp) {
         ParamSetInt($sock, "video.input.[" . $index . "].port", $port_rtsp);
      }
      return;
   }

   ParamSetInt($sock, "video.input.[" . $index . "].port", $port_rtsp);
}

function changePortTwo($port2, $arr, $sock, $index)
{
   if (!isset($port2)) {
      return;
   }

   if (isset($arr->port2)) {
      if ($arr->port2 != $port2) {
         ParamSetInt($sock, "video.input.[" . $index . "].port2", $port2);
      }
      return;
   }

   ParamSetInt($sock, "video.input.[" . $index . "].port2", $port2);
}

function changePTZ($ptz, $arr, $sock, $index)
{
   if (!isset($ptz)) {
      ParamUnset($sock, "video.input.[" . $index . "].ptz.ipptz");
      return;
   }

   if (isset($arr->ptz->ipptz)) {
      if ($arr->ptz->ipptz == $ptz) {
         return;
      }

      if ($ptz == false || $ptz == 0) {
         ParamUnset($sock, "video.input.[" . $index . "].ptz.ipptz");
         return;
      }

      ParamSetInt($sock, "video.input.[" . $index . "].ptz.ipptz", intval($ptz));
      return;
   }

   if ($ptz == false || $ptz == 0) {
      ParamUnset($sock, "video.input.[" . $index . "].ptz.ipptz");
      return;
   }
   ParamSetInt($sock, "video.input.[" . $index . "].ptz.ipptz", intval($ptz));
}

function changeCammodel($cammodel, $arr, $sock, $index)
{
   if (!isset($cammodel)) {
      return;
   }

   if (isset($arr->cammodel)) {
      if ($arr->cammodel == intval($cammodel)) {
         return;
      }

      ParamSetInt($sock, "video.input.[" . $index . "].cammodel", intval($cammodel));
      return;
   }

   ParamSetInt($sock, "video.input.[" . $index . "].cammodel", intval($cammodel));
}

function changeAudio($au, $arr, $sock, $index)
{
   if (!isset($au)) {
      return;
   }

   if (isset($arr->enabled)) {
      if ($arr->enabled === intval($au)) {
         return;
      }

      ParamSetInt($sock, "audio.input.[" . $index . "].enabled", intval($au));
      return;
   }

   ParamSetInt($sock, "audio.input.[" . $index . "].enabled", intval($au));
}

function changeUrl($url, $arr, $sock, $index)
{
   if (!isset($url) || $url == "") {
      $url = "video.input.[" . $index . "].url";
      ParamUnset($sock, $url);
      return;
   }

   if (isset($arr->url)) {
      if ($arr->url == $url) {
         return;
      }

      ParamSetString($sock, "video.input.[" . $index . "].url", $url);
      return;
   }

   ParamSetString($sock, "video.input.[" . $index . "].url", $url);
}

function changeUrlTwo($url2, $arr, $sock, $index)
{
   if (!isset($url2) || $url2 == "") {
      ParamUnset($sock, "video.input.[" . $index . "].url2");
      return;
   }

   if (isset($arr->url2)) {
      if ($arr->url2 == $url2) {
         return;
      }

      ParamSetString($sock, "video.input.[" . $index . "].url2", $url2);
      return;
   }

   ParamSetString($sock, "video.input.[" . $index . "].url2", $url2);
}

function changePortOnvif($portOnvif, $arr, $sock, $index)
{
   if (!isset($portOnvif)) {
      return;
   }

   if (isset($arr->portOnvif)) {
      if ($arr->portOnvif != $portOnvif) {
         ParamSetInt($sock, "video.input.[" . $index . "].portOnvif", $portOnvif);
      }
   } else {
      ParamSetInt($sock, "video.input.[" . $index . "].portOnvif", $portOnvif);
   }

   changePortTwo($portOnvif, $arr, $sock, $index);
}

function changePOrtHttp($portHttp, $arr, $sock, $index)
{
   if (!isset($portHttp)) {
      return;
   }
   if (isset($arr->portHttp)) {
      if ($arr->portHttp != $portHttp) {
         ParamSetInt($sock, "video.input.[" . $index . "].portHttp", $portHttp);
      }
      return;
   }

   ParamSetInt($sock, "video.input.[" . $index . "].portHttp", $portHttp);
}

function changeLocation1251($location, $arr, $sock, $index)
{
   if (!isset($location)) {
      return;
   }

   if ($location == "") {
      return ParamUnset($sock, "video.input.[" . $index . "].location1251");
   }

   if (isset($arr->location1251)) {
      if ($arr->location1251 != $location) {
         ParamSetString($sock, "video.input.[" . $index . "].location1251", $location);
         return;
      }
      return;
   }

   ParamSetString($sock, "video.input.[" . $index . "].location1251", $location);
}
